/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.resource.index;

import com.google.common.base.Preconditions;
import com.tacz.guns.client.model.BedrockAttachmentModel;
import com.tacz.guns.client.resource.ClientAssetManager;
import com.tacz.guns.client.resource.pojo.skin.attachment.AttachmentSkin;
import net.minecraft.class_2960;
import org.apache.commons.lang3.StringUtils;

public class ClientAttachmentSkinIndex {
    private BedrockAttachmentModel model;
    private class_2960 texture;
    private String name;

    private ClientAttachmentSkinIndex() {
    }

    public static ClientAttachmentSkinIndex getInstance(AttachmentSkin skinPojo) {
        ClientAttachmentSkinIndex index = new ClientAttachmentSkinIndex();
        ClientAttachmentSkinIndex.checkIndex(skinPojo, index);
        ClientAttachmentSkinIndex.checkTextureAndModel(skinPojo, index);
        return index;
    }

    private static void checkIndex(AttachmentSkin skinPojo, ClientAttachmentSkinIndex index) {
        Preconditions.checkArgument((skinPojo != null ? 1 : 0) != 0, (Object)"skin index file is empty");
    }

    private static void checkName(AttachmentSkin skinPojo, ClientAttachmentSkinIndex index) {
        index.name = skinPojo.getName();
        if (StringUtils.isBlank((CharSequence)index.name)) {
            index.name = "custom.tacz.error.no_name";
        }
    }

    private static void checkTextureAndModel(AttachmentSkin skinPojo, ClientAttachmentSkinIndex index) {
        class_2960 modelLocation = skinPojo.getModel();
        Preconditions.checkArgument((modelLocation != null ? 1 : 0) != 0, (Object)"display object missing model field");
        index.model = ClientAssetManager.INSTANCE.getOrLoadAttachmentModel(modelLocation);
        Preconditions.checkArgument((index.model != null ? 1 : 0) != 0, (Object)"there is no model data in the model file");
        class_2960 textureLocation = skinPojo.getTexture();
        Preconditions.checkArgument((textureLocation != null ? 1 : 0) != 0, (Object)"missing default texture");
        index.texture = textureLocation;
    }

    public BedrockAttachmentModel getModel() {
        return this.model;
    }

    public class_2960 getTexture() {
        return this.texture;
    }

    public String getName() {
        return this.name;
    }
}

